#region References

using System;
using System.Data;
using System.Data.SqlClient;
using System.Reflection;

using gov.va.med.vbecs.Common;

using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;

using BLOODUNITTEST = gov.va.med.vbecs.Common.VbecsTables.BloodUnitTest;
using ORDEREDTEST = gov.va.med.vbecs.Common.VbecsTables.OrderedTest;
using PATIENTTRANSFUSION = gov.va.med.vbecs.Common.VbecsTables.PatientTransfusion;
using PATIENTTRANSFUSIONCOMMENT = gov.va.med.vbecs.Common.VbecsTables.PatientTransfusionComment;
using PATIENTTRANSFUSIONREACTION = gov.va.med.vbecs.Common.VbecsTables.PatientTransfusionReaction;
using PATIENTTRANSFUSIONREACTIONSYMPTOM = gov.va.med.vbecs.Common.VbecsTables.PatientTransfusionReactionSymptom;
using PATIENTSPECIMEN = gov.va.med.vbecs.Common.VbecsTables.PatientSpecimen;
using SPECIMENTEST = gov.va.med.vbecs.Common.VbecsTables.SpecimenTest;
using TRANSFUSIONREACTION = gov.va.med.vbecs.Common.VbecsTables.TransfusionReaction;

#endregion

namespace gov.va.med.vbecs.DAL
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>David Askew</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>06/14/2004</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	/// PatientTransfusionComment data access layer class.
	///</summary>

	#endregion
	
	public class PatientTransfusionComment
	{
		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/21/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1605"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DataTable of PatientTransfusionComment schema</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1606"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Creates a DataTable of the PatientTransfusionComment table
		/// </summary>
		/// <returns>Empty DataTable</returns>
		public static DataTable GetEmptyPatientTransfusionCommentTable()
		{
			System.Data.DataTable dt = new System.Data.DataTable(PATIENTTRANSFUSIONCOMMENT.TableName);

			dt.Columns.Add(PATIENTTRANSFUSIONCOMMENT.CannedCommentGuid, typeof(Guid));
			dt.Columns.Add(PATIENTTRANSFUSIONCOMMENT.CommentCategoryCode, typeof(string));
			dt.Columns.Add(PATIENTTRANSFUSIONCOMMENT.DivisionCode, typeof(string));
			dt.Columns.Add(PATIENTTRANSFUSIONCOMMENT.LastUpdateDate, typeof(string));
			dt.Columns.Add(PATIENTTRANSFUSIONCOMMENT.LastUpdateUser, typeof(string));
			dt.Columns.Add(PATIENTTRANSFUSIONCOMMENT.PatientTransfusionCommentGuid, typeof(Guid));
			dt.Columns.Add(PATIENTTRANSFUSIONCOMMENT.PatientTransfusionCommentText, typeof(string));
			dt.Columns.Add(PATIENTTRANSFUSIONCOMMENT.PatientTransfusionGuid, typeof(Guid));
			dt.Columns.Add(PATIENTTRANSFUSIONCOMMENT.PatientTransfusionReactionGuid, typeof(Guid));
			dt.Columns.Add(PATIENTTRANSFUSIONCOMMENT.PreTransfusionIndicator, typeof(bool));
			dt.Columns.Add(PATIENTTRANSFUSIONCOMMENT.RecordStatusCode, typeof(string));
			dt.Columns.Add(PATIENTTRANSFUSIONCOMMENT.RowVersion, typeof(string));
			
			return(dt);
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/5/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1611"> 
		///		<ExpectedInput>PatientTransfusionGuid, PatientTransfusionReaction</ExpectedInput>
		///		<ExpectedOutput>DataTable of PatientTransfusionComments information</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1612"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>Argument Exception</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8091"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>Argument Exception</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8092"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>Argument Exception</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetComments
		/// </summary>
		/// <param name="patientTransfusionGuid"></param>
		/// <param name="patientTransfusionReactionGuid"></param>
		/// <param name="divisionCode"></param>
		/// <returns></returns>
		public static DataTable GetComments(Guid patientTransfusionGuid, Guid patientTransfusionReactionGuid, string divisionCode)
		{
			if (patientTransfusionGuid.Equals(Guid.Empty) && patientTransfusionReactionGuid.Equals(Guid.Empty))
			{
				throw new ArgumentException(Common.StrRes.SysErrMsg.Common.InvalidFormat("patient transfusion and patient transfusion reaction unique identifiers").ResString);
			}
			//
			if (divisionCode == null || divisionCode.Equals(string.Empty))
			{
				throw new ArgumentException(Common.StrRes.SysErrMsg.Common.InvalidFormat("division code").ResString);
			}
			//
			SqlParameter[] prms =
			{
				new SqlParameter( STOREDPROC.GetPatientTransfusionReactionComment.patienttransfusionguid, System.Data.SqlDbType.UniqueIdentifier),
				new SqlParameter( STOREDPROC.GetPatientTransfusionReactionComment.patienttransfusionreactionguid, System.Data.SqlDbType.UniqueIdentifier),
				new SqlParameter( STOREDPROC.GetPatientTransfusionReactionComment.divisioncode, System.Data.SqlDbType.Char)
			};
			
			if (patientTransfusionGuid.Equals(Guid.Empty))
			{
				prms[0].Value = DBNull.Value;
			}
			else
			{
				prms[0].Value = patientTransfusionGuid;
			}
			
			if (patientTransfusionReactionGuid.Equals(Guid.Empty))
			{
				prms[1].Value = DBNull.Value;
			}
			else
			{
				prms[1].Value = patientTransfusionReactionGuid;
			}
			
			prms[2].Value = divisionCode;
			
			return Common.StoredProcedure.GetData( STOREDPROC.GetPatientTransfusionReactionComment.StoredProcName, prms).Tables[0];
		}
	}
}
